#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Icon=FTPScreen.ico
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
;*****************************************
;FTP_Screen.au3 v1.2 by Xandy
;Created with ISN AutoIt Studio v. 1.01
;*****************************************
; If I wanted to cleanup someday, I could start here
OnAutoItExitRegister("_exit_cleanup")
; Terminates program: CTRL + PAUSE / BREAK + 13
HotKeySet("^{PAUSE}", "_exit_hotkey")
Global $gQuit = 0

; I didn't have to write any of this stuff
#include <FTPEx.au3>
#include <MsgBoxConstants.au3>
#include <ScreenCapture.au3>
#include <Misc.au3>
#include <GUIConstants.au3>
#include <File.au3>
#include "System\Include\TTS.au3"; Author: Beege
; TTS.au3: https://www.autoitscript.com/forum/topic/100439-text-to-speech-udf/
; Awesome

; Formated ScriptName
Global $gScript_name = StringTrimRight(@ScriptName, 4)
; Paths
Global $gPath_documents = @MyDocumentsDir & "\Songersoft\" & $gScript_name & "\"
Global $gPath_screenshot = $gPath_documents & "Screenshots\"
Global $gPath_settings = $gPath_documents & "Settings.txt"

; Hotkeys Data
Enum $eHotkey_data_key, _
		$eHotkey_data_shift, _
		$eHotkey_data_ctrl, _
		$eHotkey_data_alt, _
		$eHotkey_data_key_name, _
		$eHotkey_data_key_description, _
		$eHotkey_data_max

; Hotkeys enums, so that I know who is who and what is what
Enum $eHotkey_screenshot_ftp, _
		$eHotkey_screenshot_disk, _
		$eHotkey_clipboard_send, _
		$eHotkey_max

; The Hotkey array
Local $aHotkey[$eHotkey_max][$eHotkey_data_max]

; You can set your hotkeys here
; Please visit the hotkey_set() function for parameter information
hotkey_set($aHotkey, $eHotkey_screenshot_ftp, "Selected Window to FTP", "F12", "7B", 0, 1, 0); F12
hotkey_set($aHotkey, $eHotkey_screenshot_disk, "Selected Window to Disk", "S", "53", 1, 1, 1); S
hotkey_set($aHotkey, $eHotkey_clipboard_send, "Send Clipboard keystrokes", "F10", "79", 1, 1, 1); F10

; Start up the voice object
Global $gVoice = _StartTTS()

; I open and close these per FTP screenshot
; I bet it's faster to leave em' open and connected if that's your thing
Global $ghOpen = Null
Global $ghConn = Null

; Faster hotkeys?? for real? Idk never tested it but whatever
Global $ghDLL_user32 = DllOpen("user32.dll")

; This is here to send URL from clipboard to clients.
; Ultimately can be used to send the clipboard just about anywhere
; Tweek sending the clipboard keystrokes.
Opt("SendKeyDelay", 9)
Opt("SendKeyDownDelay", 5)

Enum $eSetting_screenshot_counter, _
		$eSetting_ftp_server, _
		$eSetting_ftp_username, _
		$eSetting_ftp_password, _
		$eSetting_ftp_url, _
		$eSetting_ftp_url_clipboard, _
		$eSetting_screenshot_filename, _
		$eSetting_screenshot_file_type, _
		$eSetting_voice_disabled, _
		$eSetting_max

Global $gaSetting_name[$eSetting_max]
$gaSetting_name[$eSetting_screenshot_counter] = "Screenshot Counter: "
$gaSetting_name[$eSetting_ftp_server] = "FTP Server IP: "
$gaSetting_name[$eSetting_ftp_username] = "FTP Username: "
$gaSetting_name[$eSetting_ftp_password] = "FTP Password: "
$gaSetting_name[$eSetting_ftp_url] = "FTP URL: "
$gaSetting_name[$eSetting_ftp_url_clipboard] = "FTP URL Clipboard 0|1: "
$gaSetting_name[$eSetting_screenshot_filename] = "Screenshot Filename: "
$gaSetting_name[$eSetting_screenshot_file_type] = "Type .png, .jpg, ect: "
$gaSetting_name[$eSetting_voice_disabled] = "Voice Disabled 0|1: "

; This could be some reasonable number like 50,
; and hopefully reset it's counter.. overwritting previous files on server
; I'll never know
Global $gSetting_screenshot_counter_max = 9999999

main()

Func main()

	$hGui = GUICreate(@ScriptName, 320, $eHotkey_max * 20 + 40)

	; Menu
	$menu_settings = GUICtrlCreateMenu("Tools")
	$menu_tools_configure = GUICtrlCreateMenuItem("Configure", $menu_settings)
	$menu_tools_screenshot_folder = GUICtrlCreateMenuItem("Open Screenshot folder", $menu_settings)

	; Draw GUI labels to describe hotkeys and functions
	$sHotkey = ""
	For $i = 0 To $eHotkey_max - 1
		; To build the modifier sandwich
		If $aHotkey[$i][$eHotkey_data_shift] = 1 Then $sHotkey &= "Shift "; 6
		If $aHotkey[$i][$eHotkey_data_ctrl] = 1 Then $sHotkey &= "Ctrl "; 11
		If $aHotkey[$i][$eHotkey_data_alt] = 1 Then $sHotkey &= "Alt "; 15
		; Add the hotkey name string
		$sHotkey &= "+ " & $aHotkey[$i][$eHotkey_data_key_name]

		; Modifier and Hotkey string colume
		GUICtrlCreateLabel($sHotkey, 5, 25 + $i * 20, 120, 20)
		; Hotkey description colume
		GUICtrlCreateLabel($aHotkey[$i][$eHotkey_data_key_description], 130, 25 + $i * 20, 150, 20)
		$sHotkey = ""
	Next
	; Show the GUI
	GUISetState()
	; Load user data
	Local $aSetting = load()

	Do

		$msg = GUIGetMsg()

		Switch hotkey_check($aHotkey)
			Case $eHotkey_screenshot_ftp

				$hWnd_selected = WinGetHandle("")

				screenshot_ftp($hWnd_selected, $aSetting)

				Speak("Uploaded Selected", $aSetting)

				keyreleased($aHotkey[$eHotkey_screenshot_ftp][$eHotkey_data_key])

			Case $eHotkey_screenshot_disk

				$hWnd_selected = WinGetHandle("")

				Speak("Saved", $aSetting)

				screenshot($aSetting, $hWnd_selected, $gPath_screenshot, $aSetting[$eSetting_screenshot_filename], $aSetting[$eSetting_screenshot_file_type])

				keyreleased($aHotkey[$eHotkey_screenshot_disk][$eHotkey_data_key]); S

			Case $eHotkey_clipboard_send

				_SendEx(ClipGet())

				keyreleased($aHotkey[$eHotkey_clipboard_send][$eHotkey_data_key]); F10

		EndSwitch; hotkey_check($aHotkey)

		; Ever since I was a little kid, I always liked switches
		Switch $msg
			Case $menu_tools_configure
				settings_dialog($hGui, $aSetting)
			Case $menu_tools_screenshot_folder
				ShellExecute($gPath_screenshot)
		EndSwitch; $msg

	Until $msg = $GUI_EVENT_CLOSE Or $gQuit = 1

	save($aSetting)

EndFunc   ;==>main

Func screenshot(ByRef $aSetting, $hWnd, $screenshot_path, $screenshot_name, $screenshot_type)

	DirCreate($screenshot_path)

	If $screenshot_type = "" Then $screenshot_type = ".png"

	out("Path: " & $screenshot_path & $screenshot_name & $aSetting[$eSetting_screenshot_counter] & $screenshot_type)

	_ScreenCapture_CaptureWnd($screenshot_path & $screenshot_name & $aSetting[$eSetting_screenshot_counter] & $screenshot_type, _
			$hWnd, _
			0, _
			0, _
			 - 1, _
			 - 1, _
			0)

	setting_incroment_screenshot_counter($aSetting, $gSetting_screenshot_counter_max)

	Return $aSetting[$eSetting_screenshot_counter]

EndFunc   ;==>screenshot

Func screenshot_ftp($hWin, ByRef $aSetting); setting has counter to be saved

	Local $hOpen = _FTP_Open('AutoIt Control')

	$error_ftp_open = @error

	If $hOpen = 0 Then Speak("FTP Open Error: " & $error_ftp_open, $aSetting)

	Local $hConn = _FTP_Connect($hOpen, $aSetting[$eSetting_ftp_server], $aSetting[$eSetting_ftp_username], $aSetting[$eSetting_ftp_password])

	$error_ftp_connect = @error

	If $hConn = 0 Then
		Speak("FTP Connect Error", $aSetting)
	EndIf

	If $error_ftp_open <> 0 Or $error_ftp_connect <> 0 Then
		MsgBox($MB_SYSTEMMODAL, 'screenshot_ftp()', "_FTP_Open Error?: " & $error_ftp_open & @CRLF & "_FTP_Connect Error?: " & $error_ftp_connect)
		Return
	EndIf

	; Local file_path to store screenshot
	$file_path = @ScriptDir & "\Screenshot.jpg"

	; Capture the screen to local file_path
	_ScreenCapture_CaptureWnd($file_path, _
			$hWin, _
			0, _
			0, _
			 - 1, _
			 - 1, _
			0)

	; Add FTP filename, s_ for screenshot short but fast to write?  I'm goofy.
	$ftp_path = "s_" & $aSetting[$eSetting_screenshot_counter] & ".jpg"

	; Upload local screenshot file
	$file_put = _FTP_FilePut($hConn, $file_path, $ftp_path)

	out("ftp_filePut: " & $file_put)
	out("FTP PATH: " & $ftp_path)

	; Put the URL in Clipboard
	If $aSetting[$eSetting_ftp_url_clipboard] = 1 Then
		ClipPut($aSetting[$eSetting_ftp_url] & $ftp_path)
	EndIf

	out("FTP_Close($hConn): " & _FTP_Close($hConn))
	out("FTP_Close($hOpen): " & _FTP_Close($hOpen))

	setting_incroment_screenshot_counter($aSetting, $gSetting_screenshot_counter_max)

EndFunc   ;==>screenshot_ftp

Func setting_incroment_screenshot_counter(ByRef $aSetting, $max)
	$aSetting[$eSetting_screenshot_counter] += 1
	If $aSetting[$eSetting_screenshot_counter] > $max Then $aSetting[$eSetting_screenshot_counter] = 0
EndFunc   ;==>setting_incroment_screenshot_counter

Func out($output = "", $timeout = 0);debug tool

	ConsoleWrite(@CRLF & $output);to console new line, value of $output

	;MsgBox(0, @ScriptName, $output, $timeout, $ghGui)

EndFunc   ;==>out

Func keyreleased($_key1, $_key2 = "", $_key3 = "", $_key4 = "")
	While _IsPressed($_key1, $ghDLL_user32) Or _IsPressed($_key2, $ghDLL_user32)
		Sleep(20)
	WEnd
	While _IsPressed($_key3, $ghDLL_user32) Or _IsPressed($_key4, $ghDLL_user32)
		Sleep(20)
	WEnd
EndFunc   ;==>keyreleased

Func _exit_hotkey()
	$gQuit = 1
EndFunc   ;==>_exit_hotkey

Func _SendEx($sKey, $raw = 0, $ignor = 0);when this function is called control, shift, and alt must be released before $ss keys are sent

	If $ignor = 0 Then

		While _IsPressed("10", $ghDLL_user32) Or _IsPressed("11", $ghDLL_user32) Or _IsPressed("12", $ghDLL_user32)
			Sleep(20)
		WEnd

	EndIf

	Send($sKey, $raw)

EndFunc   ;==>_SendEx

Func read_chunk($file); Remove Label from File Line Label Data pair.

	Local $chunk = FileReadLine($file)

	If @error <> 0 Then	Return ""

	Local $chunk_po = StringInStr($chunk, ": "); Find the string position of the first ": "

	Return StringMid($chunk, $chunk_po + 2); Return String 2 spaces right from the chunk_po

EndFunc   ;==>read_chunk

Func load()

	Local $aSetting[$eSetting_max]

	$file = FileOpen($gPath_settings)
	For $i = 0 To $eSetting_max - 1
		$aSetting[$i] = read_chunk($file)
	Next
	FileClose($file)

	If $aSetting[$eSetting_screenshot_counter] = 0 Then $aSetting[$eSetting_screenshot_counter] = 1

	Return $aSetting

EndFunc   ;==>load

Func save($aSetting)

	$file = FileOpen($gPath_settings, BitOR($FO_OVERWRITE, $FO_CREATEPATH))
	For $i = 0 To $eSetting_max - 1
		FileWriteLine($file, $gaSetting_name[$i] & $aSetting[$i])
	Next
	FileClose($file)

EndFunc   ;==>save

Func _exit_cleanup()
	out("Exit Cleanup()")
	out("FTP_Close($ghConn): " & _FTP_Close($ghConn))
	out("FTP_Close($ghOpen): " & _FTP_Close($ghOpen))
EndFunc   ;==>_exit_cleanup

; hotkey_set() Parameters:
; -----------------------------------------------------------
; $aHotkey -				The array hotkeys are stored in this function sets the values of this array[hotkey_id][$hotkey_data]
; $dHotkey_id - 			The enum for this hotkey index
; $sHotkey_description - 	The label displayed to the user to represent function of hotkey
; $sHotkey_name -			The hotkey it'self.  Whatever name string you want to give the key
; $dHotkey_key - 			The _IsPressed keycode
;	Keycodes AT: https://www.autoitscript.com/autoit3/docs/libfunctions/_IsPressed.htm
; $dHotkey_shift - 			Shift flag 0 or 1 Default off
; $dHotkey_ctrl - 			Ctrl flag 0 or 1 Default off
; $dHotkey_alt - 			Alt flag 0 or 1 Default off
Func hotkey_set(ByRef $aHotkey, $dHotkey_id, $sHotkey_description, $sHotkey_name, $dHotkey_key, $dHotkey_shift = 0, $dHotkey_ctrl = 0, $dHotkey_alt = 0)
	$aHotkey[$dHotkey_id][$eHotkey_data_key_description] = $sHotkey_description
	$aHotkey[$dHotkey_id][$eHotkey_data_key_name] = $sHotkey_name
	$aHotkey[$dHotkey_id][$eHotkey_data_key] = $dHotkey_key
	$aHotkey[$dHotkey_id][$eHotkey_data_shift] = $dHotkey_shift
	$aHotkey[$dHotkey_id][$eHotkey_data_ctrl] = $dHotkey_ctrl
	$aHotkey[$dHotkey_id][$eHotkey_data_alt] = $dHotkey_alt
EndFunc   ;==>hotkey_set

; Checks hotkey array
; Returns an index of triggered hotkey
Func hotkey_check($aHotkey)
	$key_trigger = -1
	For $i = 0 To $eHotkey_max - 1
		If _IsPressed($aHotkey[$i][$eHotkey_data_key], $ghDLL_user32) Then
			If _IsPressed(10, $ghDLL_user32) = $aHotkey[$i][$eHotkey_data_shift] Then
				If _IsPressed(11, $ghDLL_user32) = $aHotkey[$i][$eHotkey_data_ctrl] Then
					If _IsPressed(12, $ghDLL_user32) = $aHotkey[$i][$eHotkey_data_alt] Then
						$key_trigger = $i
						ExitLoop
					EndIf; _IsPressed(12) Alt
				EndIf; _IsPressed(11) Ctrl
			EndIf; _IsPressed(10) Shift
		EndIf; _IsPressed($aHotkey[$i][$eHotkey_data_key]
	Next; i in aHotkey
	Return $key_trigger
EndFunc   ;==>hotkey_check

Func settings_dialog($phGui, ByRef $aSetting)

	$hGui = GUICreate($gScript_name & " Settings", 400, $eSetting_max * 20 + 40, Default, Default, Default, Default, $phGui)

	Local $aControl[$eSetting_max]
	For $i = 0 To $eSetting_max - 1
		GUICtrlCreateLabel($gaSetting_name[$i], 5, 5 + $i * 20, 120, 20)
		If $i = $eSetting_ftp_password Then
			$aControl[$i] = GUICtrlCreateInput($aSetting[$i], 125, 5 + $i * 20, 400 - 135, 20, $ES_PASSWORD)
		Else
			$aControl[$i] = GUICtrlCreateInput($aSetting[$i], 125, 5 + $i * 20, 400 - 135, 20)
		EndIf
	Next

	$confirm_button = GUICtrlCreateButton("Confirm", 400 - 65, $i * 20 + 15, 55, 20)
	GUISetState(); Show the GUI

	$confirm = 0

	Do
		$msg = GUIGetMsg()
		Switch $msg
			Case $confirm_button
				$confirm = 1
				ExitLoop
		EndSwitch
	Until $msg = $GUI_EVENT_CLOSE Or $gQuit = 1

	If $confirm = 1 Then
		For $i = 0 To $eSetting_max - 1
			$aSetting[$i] = GUICtrlRead($aControl[$i])
		Next
		save($aSetting)
	EndIf

	GUIDelete($hGui)

EndFunc   ;==>settings_dialog

Func Speak($sDialog, $aSetting)
	If $aSetting[$eSetting_voice_disabled] = 0 Then	_Speak($gVoice, $sDialog)
EndFunc; Speak()
